unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Buttons, ExtCtrls, Grids, DBGrids, ActnList, SqlExpr, db,
  DialogOsoba;

type
  TFOsoby = class(TForm)
    DBGrid: TDBGrid;
    Panel1: TPanel;
    btnClose: TSpeedButton;
    btnEdit: TSpeedButton;
    btnInsert: TSpeedButton;
    btnDelete: TSpeedButton;
    StatusBar1: TStatusBar;
    procedure btnCloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnInsertClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure DBGridTitleClick(Column: TColumn);
    procedure DBGridDrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);

  private
    procedure My_edit();
    procedure My_delete();
    procedure My_insert();

  public
    procedure Pokaz_osoby();

  end;

var
  FOsoby: TFOsoby;

implementation

uses DataModule;
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TFOsoby.btnCloseClick(Sender: TObject);
begin
	Close();
end;

procedure TFOsoby.btnDeleteClick(Sender: TObject);
begin
	My_delete();
end;

procedure TFOsoby.btnEditClick(Sender: TObject);
begin
	My_edit();
end;

procedure TFOsoby.btnInsertClick(Sender: TObject);
begin
	My_insert();
end;

procedure TFOsoby.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_INSERT then
   begin
      My_insert();
   end;

   if Key = VK_RETURN then
   begin
      My_edit();
   end;

   if Key = VK_DELETE then
   begin
      My_delete();
   end;
end;

procedure TFOsoby.DBGridTitleClick(Column: TColumn);
begin
   if Column.FieldName = DM.ClientDataSet.IndexFieldNames then
   begin
      try
         DM.ClientDataSet.DeleteIndex('PESEL');
      except
         DM.ClientDataSet.AddIndex('PESEL', Column.FieldName, [ixDescending]);
         DM.ClientDataSet.IndexName := 'PESEL';
      end;
   end
   else begin
      DM.ClientDataSet.IndexName := '';
      DM.ClientDataSet.IndexFieldNames := Column.FieldName;
   end;
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   DM.ClientDataSet.Close();
   DM.SQLDataSet.Close();

	Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   FOsoby := Nil;
end;

procedure TFOsoby.FormShow(Sender: TObject);
var
	szer : Integer;

begin
   szer := Screen.Width;
   szer := szer - 40;
   FOsoby.Width := szer;

   DBGrid.DataSource := DM.ds;
	DM.SQLDataSet.Open();
   DM.ClientDataSet.Open();
end;

procedure TFOsoby.My_edit();
var
   Res  : TModalResult;  // bada w jaki sposb zostao zamkniete okno dialogowe
   ilel : Integer;       // ilo elementw w ListView

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := DM.ClientDataSet.RecordCount;
   if ilel = 0 then
   begin
      EXIT;
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self, True);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then
      begin
         Pokaz_osoby();
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.My_delete();
var
   TD      : TTransactionDesc;
   ilel    : integer;
   poz     : integer;
   idosoby : Integer;

begin
   // edycja ma sens jeeli lista nie jest pusta
   ilel := DM.ClientDataSet.RecordCount;
   if ilel = 0 then
   begin
      EXIT;
   end;

   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then
   begin
      idosoby := DM.ClientDataSet.FieldByName('IDOSOBY').AsInteger;
      try
         try
            if not DM.SQLConnection.InTransaction then
            begin
               DM.SQLDataSet.Close();

               TD.TransactionID  := 1;
               TD.IsolationLevel := xilREADCOMMITTED;

               DM.SQLConnection.StartTransaction(TD);
               DM.SQLDataSetDelete.ParamByName('IDOSOBY').AsInteger := idosoby;

               DM.SQLDataSetDelete.ExecSQL();

               DM.SQLConnection.Commit(TD);

               pokaz_osoby();

               ModalResult := mrOK;
            end
            else begin
               ShowMessage('InTransaction');
            end;
         except
            DM.SQLConnection.Rollback(TD);
            ShowMessage('Rollback');
         end;
      finally
         DM.SQLDataSetDelete.Close();
         DBGrid.SetFocus();
      end;
   end
end;

procedure TFOsoby.my_insert();
var
   Res : TModalResult;

begin
   try
      DlgOsoba := TDlgOsoba.Create(Self, False);
      res      := DlgOsoba.ShowModal();

      if res = mrOK then
      begin
         pokaz_osoby();
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.Pokaz_osoby();
begin
   DM.ClientDataSet.Close();
   DM.SQLDataSet.Close();

   DM.SQLDataSet.Open();
   DM.ClientDataSet.Open();
end;

procedure TFOsoby.DBGridDrawColumnCell(Sender: TObject; const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
   mcowosc : String;

begin
   // wywietla kolumny nazwisko i imie w innym kolorze
   if (Column.Field = DM.ClientDataSet.FieldByName('NAZWISKO')) or
      (Column.Field = DM.ClientDataSet.FieldByName('IMIE'))     then
      begin
	      DBgrid.Canvas.Font.Color := clSkyBlue;
   end
   else begin
      // DBgrid1.Canvas.Font.Color := clRed;
   end;

   // osoby ktre urudziy sie w innym miecie ni Katowice BOLD
   // DBgrid1.TitleFont.Name := 'Times new Roman';
   mcowosc := DM.ClientDataSet.FieldByName('MCOWOSC').AsString;
   if (Uppercase(mcowosc) <> 'KATOWICE') then
   begin
      // DBgrid1.Canvas.Font.Color := clBlue;
      DBgrid.Canvas.Font.Style := [fsBold];
   end
   else begin
      // DBgrid1.Canvas.Font.Color := clBlack;
   end;

   // narysuj standardowy tekst
   DbGrid.DefaultDrawDataCell(Rect, Column.Field, State);
end;

end.

